# PYTHON3
import os
import sys

from xml.dom import minidom

fileInput = str(sys.argv[1])

fileSvg = fileInput.replace(".pdf",".svg")

fileOutput = str(sys.argv[2])

# get Pages

pages = int(os.popen("pdfinfo "+fileInput+" | grep Pages").readlines()[0].split()[1])

# Split Pdf in singlepages

os.system("pdfseparate " +fileInput + " \%d.pdf")


# convert pdf-files

def transformPath(path,A,B,C,D,E,F): # transformation: see https://wiki.selfhtml.org/wiki/SVG/Transformationen
	pointsStr = path.split()
	newPoints = []

	#print(pointsStr[0:10])

	for point in pointsStr:
		if len(point) > 1:
			tempPoint = point.split(',')
			if (len(tempPoint)>1):
				x = float(tempPoint[0])
				y = float(tempPoint[1])

				newX = A*x+C*y+E
				newY = B*x+D*y+F
				newPoints.append(str(newX)+","+str(newY))
			else:
				newPoints.append(tempPoint[0])
		else:
			newPoints.append(point)

	newPath = ""
	for elem in newPoints:
		newPath +=elem+" "
	newPath = newPath[:-1]
	return newPath


def translatePath(path,translation): # translate Path
	pointsStr = path.split()
	newPoints = []

	k = 0

	for point in pointsStr:
		if k==1:
			tempPoint = point.split(',')
			x = float(tempPoint[0])
			y = float(tempPoint[1])

			newX = x+translation[0]
			newY = y+translation[1]
			newPoints.append(str(newX)+","+str(newY))
		else:
			newPoints.append(point)
		k+=1

	newPath = ""
	for elem in newPoints:
		newPath +=elem+" "
	newPath = newPath[:-1]
	return newPath


matrix1 = [0.5454546, 0, 0 	,-0.5454546	, 0, 864.2001]
matrix2 = [1.25 	,0 ,0 	,-1.25 		,0 ,1080.2501]

tempString = "<html>\n"

for k in range(1,pages+1):

	inkskapecommand = "inkscape --without-gui --file="+str(k)+".pdf" +" --export-plain-svg="+str(k)+".svg"
	os.system(inkskapecommand)

	svg = minidom.parse(str(k)+".svg")
	paths = svg.getElementsByTagName('path')

	tempString += "<p><svg height='"+ "1080" +"' width='"+ "1920" +"'>\n";

	for path in paths:
		path.attributes['d'].value

		# get transformation
		# transformation Matrix in inkskape svg, we need only tanslation: m[4] and m[5]
		parent = path.parentNode

		matrixElementsString = parent.attributes['transform'].value.replace("matrix(","").replace(")","").split(",") 

		translation = [float(matrixElementsString[4])-matrix1[4],float(matrixElementsString[5])-matrix1[5]]

		print(translation)

		pathdata = path.attributes['d'].value
		
		[a,b,c,d,e,f] = matrix1
		pathdata = transformPath(pathdata,a,b,c,d,e,f)
		pathdata = translatePath(pathdata,translation)

		[a,b,c,d,e,f] = matrix2
		pathdata = transformPath(pathdata,a,b,c,d,e,f)

		tempString += "<path fill ='none' stroke-linejoin='round' d='"+pathdata
		tempString +="' data-data='"+"0"
		tempString +="' stroke-dasharray='"+"1 0"
		tempString +="' stroke-width='"+"4"
		tempString +="' stroke-linecap='round"

		tempString +="' stroke = 'rgb(0,0,0)' />\n"

	tempString +="</svg></p>\n"

	os.remove(str(k)+".svg")
	os.remove(str(k)+".pdf")

tempString +="<goodnotes isGoodnotes ='true'></goodnotes>"
tempString +="</html>"


if os.path.exists(fileOutput):
	os.remove(fileOutput) #this deletes the file


f = open(fileOutput, "a")
f.write(tempString)
f.close()
