


"""
English

Copyright (c) <2021> <Lukasz Targas (lukasz.targas@googlemail.com)>
Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
OR OTHER DEALINGS IN THE SOFTWARE.


Deutsch

Copyright (c) <2021> <Lukasz Targas (lukasz.targas@googlemail.com)>

Jedem, der eine Kopie dieser Software und der zugehörigen Dokumentationsdateien (die "Software") erhält, wird hiermit kostenlos die Erlaubnis erteilt,
ohne Einschränkung mit der Software zu handeln, einschließlich und ohne Einschränkung der Rechte zur Nutzung, zum Kopieren, Ändern, Zusammenführen,
Veröffentlichen, Verteilen, Unterlizenzieren und/oder Verkaufen von Kopien der Software, und Personen, denen die Software zur Verfügung gestellt wird,
dies unter den folgenden Bedingungen zu gestatten:

Der obige Urheberrechtshinweis und dieser Genehmigungshinweis müssen in allen Kopien oder wesentlichen Teilen der Software enthalten sein.

DIE SOFTWARE WIRD OHNE MÄNGELGEWÄHR UND OHNE JEGLICHE AUSDRÜCKLICHE ODER STILLSCHWEIGENDE GEWÄHRLEISTUNG, EINSCHLIEßLICH, ABER NICHT BESCHRÄNKT AUF
DIE GEWÄHRLEISTUNG DER MARKTGÄNGIGKEIT, DER EIGNUNG FÜR EINEN BESTIMMTEN ZWECK UND DER NICHTVERLETZUNG VON RECHTEN DRITTER, ZUR VERFÜGUNG GESTELLT.
DIE AUTOREN ODER URHEBERRECHTSINHABER SIND IN KEINEM FALL HAFTBAR FÜR ANSPRÜCHE, SCHÄDEN ODER ANDERE VERPFLICHTUNGEN, OB IN EINER VERTRAGS- ODER
HAFTUNGSKLAGE, EINER UNERLAUBTEN HANDLUNG ODER ANDERWEITIG, DIE SICH AUS, AUS ODER IN VERBINDUNG MIT DER SOFTWARE ODER DER NUTZUNG ODER ANDEREN
GESCHÄFTEN MIT DER SOFTWARE ERGEBEN.

"""

import os
import sys

from xml.dom import minidom

fileInput = str(sys.argv[1])

fileSvg = fileInput.replace(".pdf",".svg")

fileOutput = fileInput.replace(".pdf",".html")

print(fileInput)

# get Pages

# pages = int(os.popen("pdfinfo "+fileInput+" | grep Pages").readlines()[0].split()[1])

tempPages = os.popen("pdfinfo "+fileInput+"").readlines()

pages = 0

for t in tempPages:
    if "Pages:" in t:
        pages = int(t.split()[1])


# Split Pdf in singlepages

os.system("pdfseparate " +fileInput + " %d.pdf")


# convert pdf-files

def transformPath(path,A,B,C,D,E,F): # transformation: see https://wiki.selfhtml.org/wiki/SVG/Transformationen
	pointsStr = path.split()
	newPoints = []

	#print(pointsStr[0:10])

	for point in pointsStr:
		tempPoint = point.split(',')
		if len(point) > 1:
			if (len(tempPoint)>1):
				x = float(tempPoint[0])
				y = float(tempPoint[1])

				newX = A*x+C*y+E
				newY = B*x+D*y+F
				newPoints.append(str(newX)+","+str(newY))
			else:
				newPoints.append(tempPoint[0])
		else:
			newPoints.append(point)

	newPath = ""
	for elem in newPoints:
		newPath +=elem+" "
	newPath = newPath[:-1]
	return newPath


def translatePath(path,translation): # translate Path
	pointsStr = path.split()
	newPoints = []

	k = 0

	for point in pointsStr:
		if k==1:
			tempPoint = point.split(',')
			x = float(tempPoint[0])
			y = float(tempPoint[1])

			newX = x+translation[0]
			newY = y+translation[1]
			newPoints.append(str(newX)+","+str(newY))
		else:
			newPoints.append(point)
		k+=1

	newPath = ""
	for elem in newPoints:
		newPath +=elem+" "
	newPath = newPath[:-1]
	return newPath


matrix1 = [0.5454546, 0, 0 	,-0.5454546	, 0, 864.2001]
matrix2 = [1.25 	,0 ,0 	,-1.25 		,0 ,1080.2501]

tempString = "<html>\n"

for k in range(1,pages+1):


	inkskapecommand = "inkscape --export-type=\"svg\" "+str(k)+".pdf"

	os.system(inkskapecommand)

	svg = minidom.parse(str(k)+".svg")
	paths = svg.getElementsByTagName('path')

	tempString += "<p><svg height='"+ "1080" +"' width='"+ "1920" +"'>\n";

	for path in paths:
		path.attributes['d'].value

		# get transformation
		# transformation Matrix in inkskape svg, we need only tanslation: m[4] and m[5]
		parent = path.parentNode

		matrixElementsString = parent.attributes['transform'].value.replace("matrix(","").replace(")","").split(",") 

		translation = [float(matrixElementsString[4])-matrix1[4],float(matrixElementsString[5])-matrix1[5]]

		print(translation)

		pathdata = path.attributes['d'].value
		
		[a,b,c,d,e,f] = matrix1
		pathdata = transformPath(pathdata,a,b,c,d,e,f)
		pathdata = translatePath(pathdata,translation)

		[a,b,c,d,e,f] = matrix2
		pathdata = transformPath(pathdata,a,b,c,d,e,f)

		tempString += "<path fill ='none' stroke-linejoin='round' d='"+pathdata
		tempString +="' data-data='"+"0"
		tempString +="' stroke-dasharray='"+"1 0"
		tempString +="' stroke-width='"+"4"
		tempString +="' stroke-linecap='round"

		tempString +="' stroke = 'rgb(0,0,0)' />\n"

	tempString +="</svg></p>\n"

	os.remove(str(k)+".svg")
	os.remove(str(k)+".pdf")

tempString +="<goodnotes isGoodnotes ='true'></goodnotes>"
tempString +="</html>"


if os.path.exists(fileOutput):
	os.remove(fileOutput) #this deletes the file


f = open(fileOutput, "a")
f.write(tempString)
f.close()
